unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, SmThreadUnit, EnumObjectFamily;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel3: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    Panel1: TPanel;
    Label3: TLabel;
    Panel2: TPanel;
    Label4: TLabel;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Panel4: TPanel;
    Panel5: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Button3: TButton;
    Memo2: TMemo;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button10: TButton;
    Timer1: TTimer;
    Timer2: TTimer;
    Button11: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Button12: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
    procedure ComboBox2Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  Form1  : TForm1;

implementation
{$R *.dfm}

var
  SmThread1  :  TSmThread;
  SmThread2  :  TSmThread;

// ----------------------------------------------------------------
//    1   
// ----------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
begin
   if Assigned(SmThread1) then Exit;
   ComboBox1.ItemIndex := 0;
   Timer1.Enabled := False;
   SmThread1 := TSmThread.Create(Panel1, Memo1);
   SmThread1.Prefix := '';
   SmThread1.Resume;
end;
//  
procedure TForm1.Button4Click(Sender: TObject);
begin
 if not Assigned(SmThread1) then Exit;
 Timer1.Enabled := False;
 if SmThread1.Suspended then SmThread1.Resume;
 SmThread1.Terminate;
 SmThread1.Destroy;
 SmThread1 := nil;
end;
//   
procedure TForm1.Button2Click(Sender: TObject);
begin
   Timer1.Enabled := False;
   if Assigned(SmThread1)
   then begin
     if not SmThread1.Suspended then SmThread1.Suspend;
   end;
end;
//   
procedure TForm1.Button5Click(Sender: TObject);
begin
  if Assigned(SmThread1) then SmThread1.Resume;
  if ComboBox1.ItemIndex > 0 then Timer1.Enabled := True;
end;
//     
procedure TForm1.ComboBox1Click(Sender: TObject);
begin
   Timer1.Enabled := False;
   case ComboBox1.ItemIndex of
        0: Timer1.Interval := 0;
        1: Timer1.Interval := 100;
        2: Timer1.Interval := 500;
        3: Timer1.Interval := 1000;
        4: Timer1.Interval := 1500;
        5: Timer1.Interval := 2000;
   end;
   if Timer1.Interval > 0
   then begin
      Timer1.Enabled := True;
      if Assigned(SmThread1)
      then if SmThread1.Suspended then SmThread1.Resume;
   end;
end;
//   
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if Assigned(SmThread1) then SmThread1.Resume;
end;


// ----------------------------------------------------------------
//    2   
// ----------------------------------------------------------------
//  
procedure TForm1.Button6Click(Sender: TObject);
begin
  if Assigned(SmThread2) then Exit;
  ComboBox2.ItemIndex := 0;
  Timer2.Enabled := False;
  SmThread2 := TSmThread.Create(Panel4, Memo1);
  SmThread2.Prefix := '          ';
  SmThread2.Resume;
  ComboBox2.Enabled := True;
end;
// 
procedure TForm1.Button8Click(Sender: TObject);
begin
  if not Assigned(SmThread2) then Exit;
  Timer2.Enabled := False;
  if SmThread2.Suspended then SmThread2.Resume;
  SmThread2.Terminate;
  SmThread2.Destroy;
  SmThread2 := nil;
end;
//  
procedure TForm1.Button7Click(Sender: TObject);
begin
  Timer2.Enabled := False;
  if Assigned(SmThread2)
   then begin
     if not SmThread2.Suspended then SmThread2.Suspend;
   end;
end;
//  
procedure TForm1.Button9Click(Sender: TObject);
begin
  if Assigned(SmThread2) then SmThread2.Resume;
  if ComboBox2.ItemIndex > 0 then Timer2.Enabled := True;
end;
//   
procedure TForm1.ComboBox2Click(Sender: TObject);
begin
   Timer2.Enabled := False;
   case ComboBox2.ItemIndex of
        0: Timer2.Interval := 0;
        1: Timer2.Interval := 100;
        2: Timer2.Interval := 500;
        3: Timer2.Interval := 1000;
        4: Timer2.Interval := 1500;
        5: Timer2.Interval := 2000;
   end;
   if Timer2.Interval > 0
   then begin
      Timer2.Enabled := True;
      if Assigned(SmThread2)
      then if SmThread2.Suspended then SmThread2.Resume;
   end;
end;
//    
procedure TForm1.Timer2Timer(Sender: TObject);
begin
  if Assigned(SmThread2) then SmThread2.Resume;
end;

// --------------------------------------------------------------------------
//  INFO
// --------------------------------------------------------------------------

// Info (Windows API)
procedure TForm1.Button3Click(Sender: TObject);
begin
//   TSmThread
   Memo2.Clear;
   EnumClassFamily(TSmThread, Memo2.Lines);
// PID
  // function GetCurrentProcessId: DWORD; stdcall;
  Edit4.Text:=IntToStr(Windows.GetCurrentProcessId);

// MainThreadID
  // function GetCurrentThreadId: DWORD; stdcall;
  Edit5.Text:=IntToStr(Windows.GetCurrentThreadId);
end;

//  
procedure TForm1.Button10Click(Sender: TObject);
begin
   Memo1.Clear;
end;

//   
procedure TForm1.Button11Click(Sender: TObject);
begin
    Button2Click(Sender);
    Button7Click(Sender);
end;

//   
procedure TForm1.Button12Click(Sender: TObject);
begin
    Button5Click(Sender);
    Button9Click(Sender);
end;

(*
// ---------------------------------------------------------------
//   TThread UNIT Classes.pas
// ---------------------------------------------------------------
// ---------------------------------------------------------------
//    / 
// ---------------------------------------------------------------
// UNIT System.pas
procedure ExitThread(ExitCode: Integer); stdcall;
                     external kernel name 'ExitThread';

//   -    
procedure TThread.DoTerminate;
begin
  if Assigned(FOnTerminate) then Synchronize(CallOnTerminate);
end;

procedure EndThread(ExitCode: Integer);
begin
  ExitThread(ExitCode);
end;

// ---------------------------------------------------------------
//     
// ---------------------------------------------------------------
function ThreadProc(Thread: TThread): Integer;
var
  FreeThread: Boolean;
begin
  try
    if not Thread.Terminated then
    try
      Thread.Execute;
    except
      Thread.FFatalException := AcquireExceptionObject;
    end;
  finally
    FreeThread := Thread.FFreeOnTerminate;
    Result := Thread.FReturnValue;
    Thread.DoTerminate;
    Thread.FFinished := True;
    SignalSyncEvent;
    if FreeThread then Thread.Free;
    EndThread(Result);
  end;
end;

procedure AddThread;
begin
  InterlockedIncrement(ThreadCount);
end;

constructor TThread.Create(CreateSuspended: Boolean);
begin
  inherited Create;
  AddThread;
  FSuspended := CreateSuspended;
  FCreateSuspended := CreateSuspended;
    // ---------------------------------------------
    //   (System.pas) -     ThreadProc
    // function BeginThread (SecurityAttributes: Pointer; StackSize: LongWord;
    //   ThreadFunc: TThreadFunc; Parameter: Pointer; CreationFlags: LongWord;
    //   var ThreadId: LongWord): Integer;
    // ---------------------------------------------
    FHandle := BeginThread(nil, 0, @ThreadProc, Pointer(Self), CREATE_SUSPENDED, FThreadID);
    // ---------------------------------------------
    if FHandle = 0 then
      raise EThread.CreateResFmt(@SThreadCreateError, [SysErrorMessage(GetLastError)]);
end;
// ---------------------------------------------------------------
//     
// ---------------------------------------------------------------
// UNIT Windows.pas
function CloseHandle; external kernel32 name 'CloseHandle';

procedure RemoveThread;
begin
  InterlockedDecrement(ThreadCount);  // Windows API
end;

destructor TThread.Destroy;
begin
  if (FThreadID <> 0) and not FFinished then
  begin
    Terminate;
    if FCreateSuspended then Resume;
    WaitFor;
  end;
  if FHandle <> 0 then CloseHandle(FHandle);
  inherited Destroy;
  FFatalException.Free;
  RemoveThread;
end;

*)





end.

